﻿//////////////////////////////////////////////
// Frustum.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMaths
{
	class Matrix ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Frustum final
	{			
		public :
		
			// Constructor, destructor
			Frustum () noexcept ;
			Frustum (const Frustum& other) noexcept ;

			// Getters
			const nkMaths::Vector& getPlane (unsigned int index) const ;

			// Setters
			void setPlane (const nkMaths::Vector& plane, unsigned int index) ;

			// Construction
			void buildFrustum (const nkMaths::Matrix& viewMat, const nkMaths::Matrix& projMat) ;

		private :
		
			// Attributes
			// Its planes
			nkMaths::Vector _planes [6] ;
	} ;
}